<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2020-07-26 14:55
 */
interface VatpaymentDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Vatpayment 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param vatpayment primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Vatpayment vatpayment
 	 */
	public function insert($vatpayment);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Vatpayment vatpayment
 	 */
	public function update($vatpayment);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByAmount($value);

	public function queryBySaveid($value);

	public function queryByComment($value);

	public function queryByUserid($value);

	public function queryBySysdate($value);

	public function queryByConditions($value);


	public function deleteByAmount($value);

	public function deleteBySaveid($value);

	public function deleteByComment($value);

	public function deleteByUserid($value);

	public function deleteBySysdate($value);

	public function deleteByConditions($value);


}
?>